#!/bin/csh 
# Sample Script to run Profview
# 
set echo
# This demo assumes Java is correctly installed
# 

setenv LD_LIBRARY_PATH ${ORACLE_HOME}/lib:${LD_LIBRARY_PATH}

if ($?CLASSPATH == 0) setenv CLASSPATH /net/stmeta1/private/NJDBC/NDE115

# Directory to use for unpacking profview application 
# May be changed if necessary
setenv profviewdest ${ORACLE_HOME}/plsql/demo

# Save classpath
setenv old_cp ${CLASSPATH}

# force jdbc, and ewt into the classpath
#

setenv CLASSPATH ${ORACLE_HOME}/JRE/lib/rt.jar:${CLASSPATH}
setenv CLASSPATH ${ORACLE_HOME}/jlib/ewt-3_3_18.jar:${CLASSPATH}
setenv CLASSPATH ${ORACLE_HOME}/jlib/share-1_1_9.jar:${CLASSPATH}
setenv CLASSPATH ${ORACLE_HOME}/jlib/swingall-1_1_1.jar:${CLASSPATH}

setenv CLASSPATH ${ORACLE_HOME}/jdbc/lib/classes111.zip:${CLASSPATH}

# Set up directory structure for Java class
#
pushd ${profviewdest}
mkdir oracle
cd oracle
mkdir de
cd de

echo $CLASSPATH
echo

# Extract and run the profiler viewer
setenv CLASSPATH ${profviewdest}:${profviewdest}/oracle/de:${CLASSPATH}

jar xf ${ORACLE_HOME}/plsql/demo/profview.jar
$ORACLE_HOME/JRE/bin/jre riw

# Tidyup
unsetenv profviewdest
popd
setenv CLASSPATH ${old_cp}
unsetenv old_cp
